/*
 * Decompiled with CFR 0.152.
 */
package pdfcat.util;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class PDFFunctions {
    public static void concat(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("At least one input file and an output file must be defined.");
        }
        int pageOffset = 0;
        ArrayList master = new ArrayList();
        String outFile = args[args.length - 1];
        Document document = null;
        PdfWriter writer = null;
        for (int f = 0; f < args.length - 1; ++f) {
            PdfReader reader = new PdfReader(args[f]);
            reader.consolidateNamedDestinations();
            int n = reader.getNumberOfPages();
            List bookmarks = SimpleBookmark.getBookmark(reader);
            if (bookmarks != null) {
                if (pageOffset != 0) {
                    SimpleBookmark.shiftPageNumbers(bookmarks, pageOffset, null);
                }
                master.addAll(bookmarks);
            }
            pageOffset += n;
            if (f == 0) {
                document = new Document(reader.getPageSizeWithRotation(1));
                writer = new PdfCopy(document, (OutputStream)new FileOutputStream(outFile));
                document.open();
            }
            int i = 0;
            while (i < n) {
                PdfImportedPage page = ((PdfCopy)writer).getImportedPage(reader, ++i);
                ((PdfCopy)writer).addPage(page);
            }
            ((PdfCopy)writer).freeReader(reader);
        }
        if (!master.isEmpty()) {
            writer.setOutlines(master);
        }
        document.close();
    }
}

