/*
 * Decompiled with CFR 0.152.
 */
package pdfcat.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;

public class BatchProcessor {
    public static String[] parseBatchFile(String path) throws FileNotFoundException, Exception {
        File batchfile = new File(path);
        BufferedReader reader = new BufferedReader(new FileReader(batchfile));
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = reader.readLine()) != null) {
            buffer.append(line);
        }
        String[] values = buffer.toString().split("\"");
        ArrayList<String> vals = new ArrayList<String>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i].trim().length() == 0) continue;
            vals.add(values[i]);
        }
        values = new String[vals.size()];
        vals.toArray(values);
        return values;
    }

    public static boolean importBatchFile(File batchFile, ArrayList batchfiles) {
        try {
            String[] files = BatchProcessor.parseBatchFile(batchFile.getAbsolutePath());
            for (int i = 0; i < files.length; ++i) {
                batchfiles.add(new File(files[i]));
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean writeBatchFile(ArrayList inputs, File genpdfname, File output) {
        try {
            FileWriter out = new FileWriter(output);
            for (int i = 0; i < inputs.size(); ++i) {
                out.write("\"" + ((File)inputs.get(i)).getAbsolutePath() + "\"\n");
            }
            out.write("\"" + genpdfname.getAbsolutePath() + "\"\n");
            out.flush();
            out.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

