/*
 * Decompiled with CFR 0.152.
 */
package pdfcat.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.RandomAccessFile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import pdfcat.ui.HelpDialog;
import pdfcat.util.BatchProcessor;
import pdfcat.util.PDFFunctions;

public class PDFMainFrame
extends JFrame
implements ListSelectionListener {
    private ArrayList filelocations = new ArrayList();
    private File exportFile = null;
    private ProgressDialog prog_dlg = new ProgressDialog();
    private JProgressBar progress = null;
    private static final int COL_NUM = 0;
    private static final int COL_AVAILABLE = 1;
    private static final int COL_NAME = 2;
    private static final int COL_SIZE = 3;
    private static final int COL_PROPERTY = 0;
    private static final int COL_INFO = 1;
    private String prev_dir = null;
    private JButton addButton;
    private JButton downButton;
    private JMenuItem exitButton;
    private JMenuItem exportMenuItem;
    private JButton fileButton;
    private JTextField fileLabel;
    private JButton generateButton;
    private JMenuItem helpItem;
    private JMenuItem importMenuItem;
    private JScrollPane infoScollPane;
    private JTable infoTable;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JScrollPane mainScroll;
    private JTable mainTable;
    private JButton removeButton;
    private JSplitPane splitPane;
    private JButton upButton;

    public PDFMainFrame() {
        this.initComponents();
        this.centerScreen();
        this.splitPane.setDividerLocation(0.35);
        this.setupInterface();
    }

    private void centerScreen() {
        Dimension dim = this.getToolkit().getScreenSize();
        Rectangle abounds = this.getBounds();
        this.setLocation((dim.width - abounds.width) / 1, (int)((double)(dim.height - abounds.height) / 1.5));
    }

    private void setupInterface() {
        MainTableModel mainModel = new MainTableModel();
        this.mainTable.setModel(mainModel);
        this.mainTable.getSelectionModel().addListSelectionListener(this);
        this.mainTable.getColumnModel().getColumn(0).setPreferredWidth(this.mainTable.getWidth() / 10);
        this.mainTable.getColumnModel().getColumn(1).setCellRenderer(new StatusCellRenderer());
        this.mainTable.getColumnModel().getColumn(1).setPreferredWidth(this.mainTable.getWidth() / 10);
        this.mainTable.getColumnModel().getColumn(2).setCellRenderer(new FileNameRenderer());
        this.mainTable.getColumnModel().getColumn(3).setCellRenderer(new FileSizeRenderer());
        this.mainTable.getTableHeader().setReorderingAllowed(false);
        this.mainTable.getSelectionModel().setSelectionMode(0);
        InfoTableModel infoModel = new InfoTableModel();
        this.infoTable.setModel(infoModel);
        this.infoTable.getColumnModel().getColumn(1).setCellRenderer(new InfoTableRenderer());
        this.updateInterface();
    }

    private void updateInterface() {
        int row = this.mainTable.getSelectedRow();
        if (this.filelocations.size() == 0 || this.filelocations.size() == 1) {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(this.mainTable.getSelectedRow() >= 0 && this.mainTable.getSelectedRow() < this.filelocations.size() - 1);
            this.upButton.setEnabled(this.mainTable.getSelectedRow() <= this.filelocations.size() - 1 && this.mainTable.getSelectedRow() > 0);
        }
        if (this.exportFile == null || this.filelocations.size() <= 1) {
            this.generateButton.setEnabled(false);
        } else {
            for (int i = 0; i < this.filelocations.size(); ++i) {
                File f = (File)this.filelocations.get(i);
                if (!f.exists()) {
                    this.generateButton.setEnabled(false);
                    break;
                }
                this.generateButton.setEnabled(true);
            }
        }
        this.removeButton.setEnabled(this.filelocations.size() != 0 && this.mainTable.getSelectedRows().length > 0);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.splitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.mainScroll = new JScrollPane();
        this.mainTable = new JTable();
        this.jPanel5 = new JPanel();
        this.addButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.jPanel4 = new JPanel();
        this.infoScollPane = new JScrollPane();
        this.infoTable = new JTable();
        this.generateButton = new JButton();
        this.jPanel3 = new JPanel();
        this.fileLabel = new JTextField();
        this.fileButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jMenuBar2 = new JMenuBar();
        this.jMenu2 = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.exportMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitButton = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.helpItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(3);
        this.setTitle("PDFCat");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Input File List"));
        this.mainTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.mainScroll.setViewportView(this.mainTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel2.add((Component)this.mainScroll, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/add.png")));
        this.addButton.setToolTipText("Add Input File");
        this.addButton.setMargin(new Insets(0, 0, 0, 0));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.addButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel5.add((Component)this.addButton, gridBagConstraints);
        this.downButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/Down16.gif")));
        this.downButton.setToolTipText("Move Input File Down");
        this.downButton.setMargin(new Insets(0, 0, 0, 0));
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/remove.png")));
        this.removeButton.setToolTipText("Remove Input File");
        this.removeButton.setMargin(new Insets(0, 0, 0, 0));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel5.add((Component)this.removeButton, gridBagConstraints);
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/Up16.gif")));
        this.upButton.setToolTipText("Move Input File Up");
        this.upButton.setMargin(new Insets(0, 0, 0, 0));
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        this.splitPane.setLeftComponent(this.jPanel2);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(BorderFactory.createTitledBorder("Output File Statistics"));
        this.infoScollPane.setViewportView(this.infoTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel4.add((Component)this.infoScollPane, gridBagConstraints);
        this.generateButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/Export16.gif")));
        this.generateButton.setToolTipText("Generate PDF");
        this.generateButton.setMargin(new Insets(0, 0, 0, 0));
        this.generateButton.setPreferredSize(new Dimension(40, 40));
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.generateButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(10, 0, 10, 0);
        this.jPanel4.add((Component)this.generateButton, gridBagConstraints);
        this.splitPane.setRightComponent(this.jPanel4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel1.add((Component)this.splitPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Output File"));
        this.fileLabel.setHorizontalAlignment(2);
        this.fileLabel.setText("- Not Specified -");
        this.fileLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.fileLabelActionPerformed(evt);
            }
        });
        this.fileLabel.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PDFMainFrame.this.fileLabelFocusLost(evt);
            }
        });
        this.fileLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PDFMainFrame.this.fileLabelKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                PDFMainFrame.this.fileLabelKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 0);
        this.jPanel3.add((Component)this.fileLabel, gridBagConstraints);
        this.fileButton.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/file.png")));
        this.fileButton.setToolTipText("Select Output File");
        this.fileButton.setMargin(new Insets(0, 0, 0, 0));
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.fileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 10, 10);
        this.jPanel3.add((Component)this.fileButton, gridBagConstraints);
        this.jLabel1.setFont(new Font("Dialog", 1, 10));
        this.jLabel1.setForeground(new Color(0, 51, 255));
        this.jLabel1.setText("Copyright \u00a92007 Applied Programming Technology, Inc.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.jPanel3.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jMenu2.setText("File");
        this.importMenuItem.setText("Import Batch");
        this.importMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.importMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.importMenuItem);
        this.exportMenuItem.setText("Export Batch");
        this.exportMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.exportMenuItemActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.exportMenuItem);
        this.jMenu2.add(this.jSeparator1);
        this.exitButton.setText("Exit");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.exitButtonActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.exitButton);
        this.jMenuBar2.add(this.jMenu2);
        this.jMenu1.setText("Help");
        this.helpItem.setText("Help");
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFMainFrame.this.helpItemActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.helpItem);
        this.jMenuBar2.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar2);
        this.pack();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        System.exit(1);
    }

    private void helpItemActionPerformed(ActionEvent evt) {
        HelpDialog dialog = new HelpDialog((Frame)this, true);
        dialog.setLocationRelativeTo(this);
        dialog.setSize(500, 400);
        dialog.setVisible(true);
    }

    private void exportMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = null;
        if (this.filelocations.size() < 2) {
            JOptionPane.showMessageDialog(this, "Two or more files must be selected to generate a valid batch file.");
            return;
        }
        int retval = -1;
        filechooser = this.prev_dir == null ? new JFileChooser() : new JFileChooser(this.prev_dir);
        retval = filechooser.showSaveDialog(this);
        File f = filechooser.getSelectedFile();
        if (retval != 1) {
            int overwrite;
            this.prev_dir = f.getAbsolutePath();
            if (f.exists() && (overwrite = JOptionPane.showConfirmDialog(this, "Selected file exists.  Overwrite?", "File Exists", 0)) == 1) {
                return;
            }
            boolean write = BatchProcessor.writeBatchFile(this.filelocations, this.exportFile, f);
            if (!write) {
                JOptionPane.showMessageDialog(this, "Unable to write batch file.  Verify file references are correct.");
            }
        }
        ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
        ((InfoTableModel)this.infoTable.getModel()).fireTableDataChanged();
        this.updateInterface();
    }

    private void importMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = null;
        int retval = -1;
        filechooser = this.prev_dir == null ? new JFileChooser() : new JFileChooser(this.prev_dir);
        retval = filechooser.showOpenDialog(this);
        File f = filechooser.getSelectedFile();
        if (f != null && f.exists()) {
            if (retval != 1) {
                this.prev_dir = f.getAbsolutePath();
                ArrayList files = new ArrayList();
                boolean success = BatchProcessor.importBatchFile(f, files);
                if (files.size() < 2) {
                    JOptionPane.showMessageDialog(this, "Insufficent files read.  Verify batch file format is correct.");
                    return;
                }
                if (!success) {
                    JOptionPane.showMessageDialog(this, "Unable to read batch file.  Verify file format is correct.");
                    return;
                }
                this.filelocations = new ArrayList();
                for (int i = 0; i < files.size() - 1; ++i) {
                    this.filelocations.add(files.get(i));
                }
                this.exportFile = (File)files.get(files.size() - 1);
                this.fileLabel.setText(this.exportFile.getAbsolutePath());
            }
        }
        ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
        ((InfoTableModel)this.infoTable.getModel()).fireTableDataChanged();
        this.updateInterface();
    }

    private void generateButtonActionPerformed(ActionEvent evt) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    PDFFunctions.concat(PDFMainFrame.this.getCatParams());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(PDFMainFrame.this, "Concatenation Failed: " + e.getMessage(), "Error", 0);
                }
                PDFMainFrame.this.prog_dlg.setVisible(false);
            }
        };
        try {
            int overwrite;
            if (this.exportFile.exists() && (overwrite = JOptionPane.showConfirmDialog(this, "Selected file exists.  Overwrite?", "File Exists", 0)) == 1) {
                return;
            }
            this.exportFile.createNewFile();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Unable to write to export file: " + e.getMessage());
            return;
        }
        Thread t = new Thread(run);
        t.start();
        this.prog_dlg.setLocationRelativeTo(this.jPanel1);
        this.prog_dlg.setVisible(true);
    }

    private String[] getCatParams() {
        if (this.filelocations.size() == 0 || this.exportFile == null) {
            return new String[0];
        }
        String[] params = new String[this.filelocations.size() + 1];
        for (int i = 0; i < params.length - 1; ++i) {
            File f = (File)this.filelocations.get(i);
            if (f == null || !f.exists()) continue;
            params[i] = f.getAbsolutePath();
        }
        params[this.filelocations.size()] = this.exportFile.getAbsolutePath();
        return params;
    }

    private void fileLabelKeyPressed(KeyEvent evt) {
        try {
            this.exportFile = new File(this.fileLabel.getText());
        }
        catch (Exception e) {
            this.exportFile = null;
        }
        this.updateInterface();
    }

    private void fileLabelFocusLost(FocusEvent evt) {
        this.exportFile = new File(this.fileLabel.getText());
        this.updateInterface();
    }

    private void fileLabelKeyReleased(KeyEvent evt) {
    }

    private void fileLabelActionPerformed(ActionEvent evt) {
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        Object val = this.filelocations.get(this.mainTable.getSelectedRow());
        Object val2 = this.filelocations.get(this.mainTable.getSelectedRow() + 1);
        this.filelocations.set(this.mainTable.getSelectedRow(), val2);
        this.filelocations.set(this.mainTable.getSelectedRow() + 1, val);
        int selected_row = this.mainTable.getSelectedRow();
        ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
        this.mainTable.getSelectionModel().setSelectionInterval(selected_row + 1, selected_row + 1);
        this.updateInterface();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.filelocations.remove(this.mainTable.getSelectedRow());
        this.updateInterface();
        ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
        ((InfoTableModel)this.infoTable.getModel()).fireTableDataChanged();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = null;
        filechooser = this.prev_dir == null ? new JFileChooser() : new JFileChooser(this.prev_dir);
        int returnVal = filechooser.showOpenDialog(this);
        File f = filechooser.getSelectedFile();
        if (returnVal != 1 && f != null) {
            this.prev_dir = f.getAbsolutePath();
            if (!f.getName().endsWith(".pdf")) {
                JOptionPane.showMessageDialog(this, "File: " + f.getName() + " - does not end in .pdf", "Verify PDF", 2);
            }
            if (!f.exists()) {
                JOptionPane.showMessageDialog(this, "File: " + f.getName() + " - could not be located", "Verify PDF", 2);
            } else {
                this.filelocations.add(f);
                this.updateInterface();
                ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
                ((InfoTableModel)this.infoTable.getModel()).fireTableDataChanged();
            }
        }
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        JFileChooser filechooser = null;
        filechooser = this.prev_dir == null ? new JFileChooser() : new JFileChooser(this.prev_dir);
        int returnVal = filechooser.showOpenDialog(this);
        File f = filechooser.getSelectedFile();
        if (returnVal != 1 && f != null) {
            this.prev_dir = f.getAbsolutePath();
            this.fileLabel.setText(f.getAbsolutePath());
            this.exportFile = f;
        }
        this.updateInterface();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        Object val = this.filelocations.get(this.mainTable.getSelectedRow());
        Object val2 = this.filelocations.get(this.mainTable.getSelectedRow() - 1);
        this.filelocations.set(this.mainTable.getSelectedRow(), val2);
        this.filelocations.set(this.mainTable.getSelectedRow() - 1, val);
        int selected_row = this.mainTable.getSelectedRow();
        ((MainTableModel)this.mainTable.getModel()).fireTableDataChanged();
        this.mainTable.getSelectionModel().setSelectionInterval(selected_row - 1, selected_row - 1);
        this.updateInterface();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PDFMainFrame().setVisible(true);
            }
        });
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateInterface();
    }

    private class ProgressDialog
    extends JDialog {
        public ProgressDialog() {
            super((Frame)PDFMainFrame.this, true);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel prog_label = new JLabel();
            prog_label.setText("Generating PDF");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)prog_label, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            PDFMainFrame.this.progress = new JProgressBar();
            this.setSize(250, 100);
            PDFMainFrame.this.progress.setIndeterminate(true);
            PDFMainFrame.this.progress.setSize(100, 100);
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            this.add((Component)PDFMainFrame.this.progress, gridBagConstraints);
            PDFMainFrame.this.progress.setVisible(true);
        }
    }

    private class InfoTableRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private InfoTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1 && row == 1) {
                Integer i = (Integer)value;
                DecimalFormat decimal_format = new DecimalFormat("0.0##");
                double orig_megs = (double)i.intValue() / 1024.0 / 1000.0;
                return super.getTableCellRendererComponent(table, decimal_format.format(orig_megs), isSelected, hasFocus, row, column);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class FileNameRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private FileNameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            File f = (File)value;
            return super.getTableCellRendererComponent(table, f.getName(), isSelected, hasFocus, row, column);
        }
    }

    private class FileSizeRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private FileSizeRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Integer i = (Integer)value;
            DecimalFormat decimal_format = new DecimalFormat("0.0##");
            double orig_megs = (double)i.intValue() / 1024.0 / 1000.0;
            this.setHorizontalAlignment(4);
            return super.getTableCellRendererComponent(table, decimal_format.format(orig_megs), isSelected, hasFocus, row, column);
        }
    }

    private class StatusCellRenderer
    implements TableCellRenderer {
        private JLabel valid_label = new JLabel();
        private JLabel invalid_label = new JLabel();

        private StatusCellRenderer() {
            this.valid_label.setHorizontalAlignment(0);
            this.invalid_label.setHorizontalAlignment(0);
            this.valid_label.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/valid.png")));
            this.invalid_label.setIcon(new ImageIcon(this.getClass().getResource("/pdfcat/images/invalid.png")));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean val = (Boolean)value;
            if (val.booleanValue()) {
                return this.valid_label;
            }
            return this.invalid_label;
        }
    }

    private class InfoTableModel
    extends AbstractTableModel {
        private InfoTableModel() {
        }

        @Override
        public int getRowCount() {
            return 3;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (rowIndex) {
                case 0: {
                    if (columnIndex == 0) {
                        return "Num. Files";
                    }
                    return PDFMainFrame.this.filelocations.size();
                }
                case 1: {
                    if (columnIndex == 0) {
                        return "Est. Size";
                    }
                    return this.getTotalBytes();
                }
                case 2: {
                    if (columnIndex == 0) {
                        return "Valid Status";
                    }
                    return this.getValidStatus();
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Property";
                }
                case 1: {
                    return "Info.";
                }
            }
            return "";
        }

        private int getTotalBytes() {
            int bytes = 0;
            for (int i = 0; i < PDFMainFrame.this.filelocations.size(); ++i) {
                if (!((File)PDFMainFrame.this.filelocations.get(i)).exists()) continue;
                try {
                    RandomAccessFile raf = new RandomAccessFile((File)PDFMainFrame.this.filelocations.get(i), "r");
                    bytes = (int)((long)bytes + raf.length());
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return bytes;
        }

        private boolean getValidStatus() {
            if (PDFMainFrame.this.filelocations.size() <= 1) {
                return false;
            }
            for (int i = 0; i < PDFMainFrame.this.filelocations.size(); ++i) {
                if (((File)PDFMainFrame.this.filelocations.get(i)).exists()) continue;
                return false;
            }
            return true;
        }
    }

    private class MainTableModel
    extends AbstractTableModel {
        private MainTableModel() {
        }

        @Override
        public int getRowCount() {
            return PDFMainFrame.this.filelocations.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return rowIndex + 1;
            }
            if (columnIndex == 1) {
                boolean available = false;
                try {
                    File f = (File)PDFMainFrame.this.filelocations.get(rowIndex);
                    available = f.exists();
                }
                catch (Exception e) {
                    available = false;
                }
                return available;
            }
            if (columnIndex == 2) {
                if (((File)PDFMainFrame.this.filelocations.get(rowIndex)).exists()) {
                    return (File)PDFMainFrame.this.filelocations.get(rowIndex);
                }
                return null;
            }
            try {
                File f = (File)PDFMainFrame.this.filelocations.get(rowIndex);
                if (!f.exists()) {
                    return 0;
                }
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                return (int)raf.length();
            }
            catch (Exception e) {
                return 0;
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Order";
                }
                case 1: {
                    return "Status";
                }
                case 2: {
                    return "Name";
                }
                case 3: {
                    return "Size (megs)";
                }
            }
            return "";
        }
    }
}

