/*
 * Decompiled with CFR 0.152.
 */
package pdfcat;

import java.io.FileNotFoundException;
import pdfcat.ui.PDFMainFrame;
import pdfcat.util.BatchProcessor;
import pdfcat.util.PDFFunctions;

public class Main {
    public static void main(String[] args) {
        block11: {
            if (args.length > 0 && args[0].startsWith("-h")) {
                System.err.println("\nPDFCat Version 1.0\nCopyright (c) 2007 Applied Programming Technology, Inc.\n\nPDFCat merges a series of pdf files into a single pdf file preserving\nbookmarks contained in the input pdf files.  The Java based application\ncan be run interactively or in batch mode.\n\nCommand Line Syntax:\n     java -jar PDFCat [-h | -b <Batch File>]\n\nWhere:\n    -h : Print this message and exit.\n    -b <Batch File> : Run the batch file and exit\n\nThe program runs in iteractive mode if no arguments are provided.\n\nThe interactive mode provides a User Interface which includes a table\nof input files along with output file statistics. Using the up and down\narrows located below the information table adjusts the order in which the\npdf files will be merged.  Selecting the page icons will either add or\nremove a pdf file from the merge list, respectively.\n\nThe output file can be specified manually by entering the output file name\nin the text field or by using the file chooser button.  Once the input and\noutput files have been specified, the concatenation button located below the\ninformation table will be enabled.  Pressing the concatenation button will\ngenerate the pdf file. \nBatch files can be exported from the interactive UI by selecting the\n\"File\"->\"Export\" menu item.  A batch file may be imported for editing\nby using the \"File\"->\"Import\" menu item.\n(Note:  All batch file name entrys must be double quoted)\n\nThis software includes the iText library available under Mozzila Public\nLicensing from:\n\n     http://www.lowagie.com/iText/\n\n");
                System.exit(0);
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("-b")) {
                try {
                    String[] arguments = BatchProcessor.parseBatchFile(args[1]);
                    if (arguments != null && arguments.length > 0) {
                        try {
                            PDFFunctions.concat(arguments);
                        }
                        catch (Exception e) {
                            System.err.println("Concatenation Failed: " + e.getMessage() + "\n");
                            e.printStackTrace();
                        }
                        System.err.println("Merge Process Complete.");
                        break block11;
                    }
                    System.err.println("The specified batch file is invalid. ");
                    System.err.println("Format: <input file 1> <input file 2> . . . <input file N> <output file>");
                }
                catch (FileNotFoundException fnf) {
                    System.err.println("Unable to locate batch file: " + args[1] + "." + " Verify the correct path is specified.");
                }
                catch (Exception e) {
                    System.err.println("Error reading batch file: " + args[1] + " - " + e.getMessage());
                }
            } else if (args.length > 0) {
                System.err.println("Invalid arguments");
                System.err.println("Syntax: java -jar PDFCat.jar [-h | -b <batch filename>]");
            } else {
                PDFMainFrame mainFrame = new PDFMainFrame();
                mainFrame.setSize(500, 500);
                mainFrame.setVisible(true);
            }
        }
    }
}

