// Copyright (c) 2002-2003 Applied Programming Technology, Inc.
// This Software was developed for the USNRC under Contract NRC-04-03-057
// and Purdue Subcontract Agreement 640-0894-1 under NRC Prime Contract 
// no. NRC-04-97-046 (Task #6).
// All rights reserved.
// 
/*
 * ExamplePluginData.java
 *
 * Created on August 30, 2003, 9:15 AM
 */

package example_plugin;

import com.cafean.CodePlugins.MEPlugin;
import com.cafean.CodePlugins.MEPluginData;

/** This contains all the data necessary when reading in a plugin to determine
 * what order that plugin should be read in, and whether the user has the appropriate
 * version for plugins that depend on a specific version of the plugin.
 */
public class ExamplePluginData extends MEPluginData {
    
    /** The plugin specific unique label */
    public static final String LABEL = "EXAMPLE";
    
    /** The absolute path of the plugin class */
    public static final String CLASS = "nrcsnap.modelEditor.example_plugin.ExamplePlugin";
    
    /** The Current Version number */
    public static final String VERSION = "0.1.0";
    
    /** The info string for the help dialog */
    public static final String INFO = "Simple plugin that provides an example implementation of a feature plugin.";
    
    public static final String[] prereqs = new String[0];
    
    /** Creates a new instance of ExamplePluginData */
    public ExamplePluginData() {
    }
    
    /** RELAP5 has no Class prerequisites.
     *@return A String array of length 0.
     */
    public String[] getClassPrereqs() {
        return new String[] {};
    }
    
    /** {@inheritDoc} */
    public String getPluginId() {
        return LABEL;
    }
    
    /** {@inheritDoc} */
    public String getPluginClass() {
        return CLASS;
    }
    
    /** This Example has no Plugin prerequisites.
     *@return A String array of length 0.
     */
    public String[] getPluginPrereqs() {
        return prereqs;
    }
    
    /** {@inheritDoc} */
    public String getVersion() {
        return VERSION;
    }
    
    /** {@inheritDoc} */
    public MEPlugin loadPlugin()
    {
        return new ExamplePlugin();
    }
}
