// Copyright (c) 2002-2005 Applied Programming Technology, Inc.
// This Software was developed for the USNRC under Contract NRC-04-03-057
// All rights reserved.
// 
package example_plugin;

import com.apt.xdr.PibFile;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import com.cafean.client.analysis.AbstractModel;
import com.cafean.client.analysis.ViewComponent;
import com.cafean.client.ui.DrawnComponent;
import com.cafean.client.ui.DrawnView;
import com.cafean.client.ui.MainFrame;
import com.cafean.utils.OptionPane;

/**
 * This is a simple feature plugin used as an illustrative example of how to write a plugin.
 * It adds two menu items to the main menubar on the main application window.
 * The first menu item, added to the edit menu simply opens a "Hello World" dialog.
 * The second menu item, added to the tools menu will display the number of DrawnComponents 
 * in each open view of the current model to the MessageWindow.
 */
public class ExamplePlugin extends com.cafean.CodePlugins.MEFeaturePlugin
{
    /** Creates a new instance of ExamplePlugin */
    public ExamplePlugin()
    {
        super("Put short Description here.");
    }

    public String getPluginId()
    {
        return ExamplePluginData.LABEL;
    }

    public String getPluginInfo()
    {
        return ExamplePluginData.INFO;
    }

    public String[] getPluginPrereqs()
    {
        return ExamplePluginData.prereqs;
    }

    public String getVersion()
    {
        return ExamplePluginData.VERSION;
    }

    /** {@inheritDoc} **/
    public void loadMainMenuItems()
    {
        AbstractAction example1 = new AbstractAction("Example 1") {
            public void actionPerformed(ActionEvent evt)
            {
                example1MenuItemActionPerformed(evt);
            }
        };

        AbstractAction example2 = new AbstractAction("Example 2") {
            public void actionPerformed(ActionEvent evt)
            {
                example2MenuItemActionPerformed(evt);
            }
        };
        MainFrame.addMenuItem(new JMenuItem(example1), "EDIT");
        MainFrame.addMenuItem(new JMenuItem(example2), "TOOLS");
    }

    /** {@inheritDoc} **/
    public void loadViewMenuItems(DrawnView view)
    {
        // not used here.
    }

    /** {@inheritDoc} **/
    public void loadSettings(com.cafean.utils.Configurator config)
    {
        // not used here.
    }

    /** {@inheritDoc} **/
    public void processCommand(java.util.Vector cmdVect)
    {
        // no commands for this Example.
    }

    /** {@inheritDoc} **/
    public void storeSettings(com.cafean.utils.Configurator config)
    {
        // noop
    }

    /** {@inheritDoc} **/
    public void load(com.cafean.client.analysis.AbstractModel loadedModel, PibFile pibfile)
    {
        // noop
    }

    /** {@inheritDoc} **/
    public void modelAdded(com.cafean.client.analysis.AbstractModel model)
    {
        // noop
    }

    /** {@inheritDoc} **/
    public void modelRemoved(com.cafean.client.analysis.AbstractModel model)
    {
        // noop
    }

    /** {@inheritDoc} **/
    public void save(com.cafean.client.analysis.AbstractModel savedModel, PibFile pibfile)
    {
        // noop
    }

    /** {@inheritDoc} **/
    public boolean isAssociated(AbstractModel model)
    {
        return false;
    }

    private void example1MenuItemActionPerformed(java.awt.event.ActionEvent evt)
    {
        OptionPane.showMessageDialog(MainFrame.instance, "Hello World!");
    }

    private void example2MenuItemActionPerformed(java.awt.event.ActionEvent evt)
    {
        if(MainFrame.getCurrentModel() != null) {
            Iterator itr = MainFrame.getCurrentModel().getComponentIterator( AbstractModel.CAT_VIEW );
            if(!itr.hasNext()) {
                MainFrame.addMessage("The model contains no views.");
            } else {
                while( itr.hasNext() ){
                    ViewComponent vc = ( (ViewComponent)itr.next() );
                    DrawnView dv =  vc.getDrawnView();
                    if(dv != null) {
                       DrawnComponent[] drawnComponents = dv.getDrawnComponents();
                       MainFrame.addMessage("View: \""+vc.getName()+"\" contains "+drawnComponents.length+" drawn components.");
                    } else {
                       MainFrame.addMessage("View: \""+vc.getName()+"\" is not open.");
                    }                        
                }
            }
        } else {
            OptionPane.showMessageDialog(MainFrame.instance, "No open model.");
        }
    }
}