#
# The following is an example of how to retrieve data from TRACE vessel components.
# The calculations performed with this data are not necessarily usefull or
# appropriate but serve only as examples of how the values used can be retrieved
# from the model.
#
#

# Pre-Defined Methods:

### 
 # Retrieves the current model.
 # In batch mode the model retrieved is either the current model
 # (the last model opened, imported, etc.) or the model specified
 # by key in the MACRO command.
###
# def getModel():

### 
 # Prints the given message to the Message Window as a Notice.
###
# def addMessage(message):
addMessage( "Beginning Python data access example for TRACE Vessel using W4loopn.med")

#
# In the following example, various values of Vessel #10 will be displayed
# as messages in the Message Window
#

# Find vessel number 10 by using it's component number and category name.
vessel = findComponent("Vessels",26)
# Note: The category name is the name of the category as it appears in
#       the Navigator. Using the singular "Vessel" in this case will not
#       find the component and will throw an exception.

# Print the component's string representation to the Message Window
addMessage( "Example Component: "+str(vessel) )

# This is a set of lines from the Vessel ASCII export routine rewritten in python. 
addMessage( "*******   type           num            id        ctitle" )
addMessage( "vessel                        %d             %d          %s" \
                # the vessel's component number
            % ( vessel.getComponentNumber(), \
                # Arbitrary user-defined ID
                0, \
                # the toString of the component.
                vessel.toString()) ) 
                # toString() generates a human-readable string representation 
                # of the component for use in messages, selections, etc.
addMessage("*         nasx          nrsx          ntsx         shelv")
addMessage(" %13d %13d %13d %13s" % \
           (vessel.getNasx(), vessel.getNrsx(), vessel.getNtsx(), \
            vessel.getShelv() ) )


#
# This example shows a display volume for each axial level and planar cell.
#
addMessage("Vessel Cell Volumes")
nasx = vessel.getNasx() # Number of axial vessel levels
planars = vessel.getNrsx() * vessel.getNtsx(); # number of planar cells
addMessage("level  planar  volume")
level = 0 # current axial level
while level < nasx:
    planar = 0 # current planar cell
    while planar < planars:
        cell = vessel.getCellAt(planar,level)
        # Most data values follow the naming convention found in the TRACE user's manual.
        # Accessors for these values follow the Java naming convention. 
        # ( First letter is lower case; Each successive word is capitalized. )
        addMessage("  %d      %d     %s" \
                      # offset indexes to fortran notation
                   %( (level+1), (planar+1), \
                   # use the Real class's built-in formatting for vol
                       cell.getVol().toString() ) )
        planar += 1 # next planar cell
        # similar code can be used to retrieve other cell values such as:
        # getAlp(), getTl(), getTv(), getP(), getConc(), getS(), etc.
    level += 1 # next axial level


#
# This example shows a display hydraulic diameter for each 
# axial level and planar cell.
#
addMessage("Vessel Edge Hydraulic Diameters")
nasx = vessel.getNasx() # Number of axial vessel levels
planars = vessel.getNrsx() * vessel.getNtsx(); # number of planar cells
addMessage("%5s %6s %14s %14s %14s"% \
           ("axial","planar","hdxr","hdyt","hdz"))
level = 0 # current axial level
while level < nasx:
    planar = 0 # current planar cell
    while planar < planars:
        # Most data values follow the naming convention found in the TRACE user's manual.
        # Accessors for these values follow the Java naming convention. 
        # ( First letter is lower case; Each successive word is capitalized. )
        addMessage("%5d %6d %14s %14s %14s"% \
                      # offset indexes to fortran notation
                   ( (level+1), (planar+1), \
                   # use the Real class's built-in formatting for HD
                      vessel.getEdgeAt(planar,level,0).getHd().toString(),
                      vessel.getEdgeAt(planar,level,1).getHd().toString(),
                      vessel.getEdgeAt(planar,level,2).getHd().toString() ) )
        planar += 1 # next planar cell
        # similar code can be used to retrieve other edge values such as:
        # getVl() and getVv()
    level += 1 # next axial level
