#
# The following is an example of how to retrieve data from TRACE pipe comonents.
# The calculations performed with this data are not necessarily usefull or
# appropriate but serve only as examples of how the values used can be retrieved
# from the model.
#
#

# Pre-Defined Methods:

### 
 # Retrieves the current model.
 # In batch mode the model retrieved is either the current model
 # (the last model opened, imported, etc.) or the model specified
 # by key in the MACRO command.
###
# def getModel():

### 
 # Prints the given message to the Message Window as a Notice.
###
# def addMessage(message):
addMessage( "Beginning Python data access example for TRACE Pipe using W4loopn.med")

#
# In the following example, various values of Pipe #2 will be displayed
# as messages in the Message Window
#

# Find pipe number 2 by using it's pipeonent number and category name.
pipe = findComponent("Pipes",2)
# Note: The category name is the name of the category as it appears in
#       the Navigator. Using the singular "Pipe" in this case will not
#       find the pipeonent and will throw an exception.

# Print the pipeonent's string representation to the Message Window
addMessage( "Example Component: "+str(pipe) )

# This is a set of lines from the Pipe ASCII export routine rewritten in python. 
addMessage( "*******   type           num            id        ctitle" )
addMessage( "pipe                       %d             %d          %s" \
                # the pipe's pipeonent number
            % ( pipe.getComponentNumber(), \
                # Arbitrary user-defined ID
                0, \
                # the toString of the pipeonent.
                pipe.toString()) ) 
                # toString() generates a human-readable string representation 
                # of the pipeonent for use in messages, selections, etc.
                                   
# This example show some real data being retrieved from the pipe.
# NCELLS: This value is the number of cells in the first fluid segment
#         (main tube/side tube) of a fluid such as a Pipe or a Tee.
#         NCELLS2 would be retrieved with: pipe.getFluidSegment(1).getCellsCount()
#
# JUN1: This is the pipeonent number of the connection representing the
#       pipe's inlet junction. This is a convenience method that handles
#       the 0 junction number for an unconnected inlet.
#
# JUN2: The same as JUN1 for the outlet connection. 
#       getJun3CC() is also available for compnents with 2 fluid segments.(tee)
#
# EPSW: Wall surface roughness.
#       The important thing to note here is that EPSW is not a float, it is an
#       object of Length. Length is a TRACE specific extension of Real which
#       is used to allow the display of numbers in either SI or British units.
#
#       NOTE: To retrieve the float value of a Real object the getDoubleValue()
#             method must be used. Also note that the value returned is always
#             in SI units.
#
addMessage( "*       ncells         nodes          jun1          jun2          epsw" )
addMessage( "             %d             %d             %d             %d          %f" \
            %( pipe.getFluidSegment(0).getCellsCount(), \
               pipe.getNodes(), \
               pipe.getJun1CC(), pipe.getJun2CC(), \
               pipe.getEpsw().getDoubleValue()) ) # Note the use of getDoubleValue()

#
# This is an example of retrieving data directly from a pipe's cells in
# order to calculate the pipe's total length and volume.
#
totalLength = 0.0 # initial value of 0.0
totalVolume = 0.0 # initial value of 0.0
idx = 0           # Current cell index. 
                  # Note that all indexes are in C notation {0 to (n-1)}
while idx < pipe.getCellCount(): 
#   getCellCount is the total number of cells in the component.
    cell = pipe.getCellAt(idx)
    # Most data values follow the naming convention found in the TRACE user's manual.
    # Accessors for these values follow the Java naming convention. 
    # ( First letter is lower case; Each successive word is capitalized. )
    totalLength += cell.getDx().getDoubleValue()
    totalVolume += cell.getVol().getDoubleValue()
    idx += 1 # next cell
    # similar code can be used to retrieve other cell values such as:
    # getAlp(), getTl(), getTv(), getP(), getConc(), getS(), etc.
    
addMessage( "Total Length: %1.3f m" % totalLength )
addMessage( "Total Volume: %1.3f m^3" % totalVolume )

#
# This example shows retrieving data from a pipe's edges for displaying
# each edge's flow area, hydraulic diameter and GRAV.
#
idx = 0           # Current edge index. 
                  # Note that all indexes are in C notation {0 to (n-1)}
addMessage( "   %4s %14s %14s %14s" %( "edge", "flow area", "hyd diam", "grav" ) )

while idx < pipe.getEdgeCount():# getEdgeCount is the total number of edges
    # findEdgeAt must be used rather than getEdgeAt to retrieve the appropriate
    # edge when edge data is being shared between fluid components.
    # Edge data that would be duplicated in the TRACE ASCII deck is shared
    # in the plugin.
    edge = pipe.findEdgeAt(idx) 
    # Display the edge number, flow area, hydraulic diameter and grav term.
    # Use the toString for FA and HD in order to use the number formatting
    # features of the Real class.
    addMessage( "   %4d %14s %14s %14f" % \
                   #adjust idx to fortran notation {1-n}
                ( (idx+1), \
                  edge.getFa().toString(), \
                  edge.getHd().toString(), \
                  edge.getGrav() ) )
    idx += 1 # next edge
    # similar code can be used to retrieve other edge values such as:
    # getFric(), getFricr(), getVl(), getVv(), getHd_ht()
