#
# The following is an example of how to retrieve data from TRACE fill comonents.
# The calculations performed with this data are not necessarily usefull or
# appropriate but serve only as examples of how the values used can be retrieved
# from the model.
#
#

# Pre-Defined Methods:

### 
 # Retrieves the current model.
 # In batch mode the model retrieved is either the current model
 # (the last model opened, imported, etc.) or the model specified
 # by key in the MACRO command.
###
# def getModel():

### 
 # Prints the given message to the Message Window as a Notice.
###
# def addMessage(message):
addMessage( "Beginning Python data access example for TRACE Fill using W4loopn.med")

#
# In the following example, various values of fill #8 will be displayed
# as messages in the Message Window
#

# Find fill number 8 by using it's component number and category name.
fill = findComponent("Fills",8)
# Note: The category name is the name of the category as it appears in
#       the Navigator. Using the singular "Fill" in this case will not
#       find the component and will throw an exception.

# Print the component's string representation to the Message Window
addMessage( "Example Component: "+str(fill) )

# This is a set of lines from the fill ASCII export routine rewritten in python. 
addMessage( "*******   type           num            id        ctitle" )
addMessage( "fill                       %d             %d         %s" \
                # the fill's component number
            % ( fill.getComponentNumber(), \
                # Arbitrary user-defined ID
                0, \
                # the toString of the component.
                fill.toString()) ) 
                # toString() generates a human-readable string representation 
                # of the component for use in messages, selections, etc.
addMessage("*         jun1          ifty          ioff")
addMessage("%13s %13d %13d" % (fill.getJun1CC(), fill.getIfty(), fill.getIoff()) )
